package gov.va.vamf.scheduling.varutility.domain;


import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class CustomRequestSettings extends DomainBaseObjects<CustomRequestSetting> {

    public ArrayList<ValidationError> validate(List<ClinicalServices> clinicalServices) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        validateExpressCareRequired(errors);
        validateSubmittedRequestLimit(errors, clinicalServices);
        return errors;
    }

    private void validateExpressCareRequired(ArrayList<ValidationError> errors) {

        for (CustomRequestSetting c: this) {
            if (c.getSupported().equals(true)) {
                Boolean atLeastOneDay = false;
                SchedulingDays schedulingDays = c.getSchedulingDays();
                for (SchedulingDay schedulingDay: schedulingDays) {
                    if (schedulingDay.getCanSchedule().equals(true)) {
                        atLeastOneDay = true;
                        if (schedulingDay.getStartTime() == null || schedulingDay.getStartTime().equals("")) {
                            errors.add(new ValidationError(c.getTypeOfCare(), "Start Time is required."));
                        }
                        if (schedulingDay.getEndTime() == null || schedulingDay.getEndTime().equals("")) {
                            errors.add(new ValidationError(c.getTypeOfCare(), "End Time is required."));
                        }
                    }
                }
                if (!atLeastOneDay) {
                    errors.add(new ValidationError(c.getTypeOfCare(), "At least one day must be selected to support an Express Care request."));
                }
            }
        }

    }

    private void validateSubmittedRequestLimit(ArrayList<ValidationError> errors, List<ClinicalServices> clinicalServices) {
        Map<String, Integer> serviceSubmittedRequestLimits = new HashMap<String, Integer>();
        for (ClinicalServices clinicalService : clinicalServices) {
            serviceSubmittedRequestLimits.put(clinicalService.getId(), clinicalService.getSubmittedRequestLimit());
        }
        for(CustomRequestSetting c : this) {
            if (c.getSubmittedRequestLimit() == null) {
                errors.add(new ValidationError(c.getTypeOfCare(),
                        "Submitted Request Limit is required"));
            } else {
                if (c.getSubmittedRequestLimit() > serviceSubmittedRequestLimits.get(c.getId())) {
                    errors.add(new ValidationError(c.getTypeOfCare(), "Submitted Request Limit cannot be more than " + serviceSubmittedRequestLimits.get(c.getId())));
                }
            }
        }
    }
}
